*Title: Moving activeCollab to Another Server
*Slug: moving-activecollab-to-another-server

================================================================

If necessary, **you can move your activeCollab setup to another server at any time**.

<{note title="Server System Requirements"}>Before moving your activeCollab installation,  make sure that your new server meets the system requirements, so that activeCollab will be able to run smoothly. You can find the detailed list of all the requirements in the <{page name='system-requirements'}>following article<{/page}>..<{/note}>


When you are ready to start, please follow these steps:

<{step num=1}>**Requesting a New URL**<{/step}>

<{note}>This step is necessary only if you wish to change the URL of your activeCollab. If  you want to keep the same URL, please skip this step and move forward to the next one.<{/note}>

To change the URL of your activeCollab instance, you will need to request the URL change on your <a href=https://www.activecollab.com/my-profile>activeCollab.com profile page</a>:

- Login to your profile page by using your activeCollab.com username and password.
- Click the <{option}>Change<{/option}> link next to license URL in the license details section.

Your activeCollab URL on our website will be changed automatically (in case you have asked for the URL change 3 times in a row, you have to wait for a manual approval).

After you receive an email confirming that your URL has been changed, download the license.php from our website and replace the it in the config folder of your activeCollab setup. Make sure that you clear <{path}>/cache<{/path}> and <{path}>/compile<{/path}> folders after the license.php replacement.

<{step num=2}>**Installing activeCollab on a New Server**<{/step}>

To install a fresh copy of activeCollab on your new server, download the activeCollab installation files on your <a href=https://www.activecollab.com/my-profile>activeCollab.com profile page</a>.

<{note title="Table Prefixes"}>When creating a new MySQL database, please make sure that you use the same table prefix that you used for original setup. The prefix is usually "acx_".<{/note}>

<{step num=3}>**Moving Data from the Old Server**<{/step}>

You are now ready to move the data from old setup - you have the new URL and a fresh copy of activeCollab installed.

First **move your activeCollab database**. To make sure all data is transfered successfully, do the following:

- Visit your setup on the new server and drop all activeCollab tables that the installer has created.
- Export tables and data from the old setup.
- Import the old (exported) data into a new database.

The migration can be performed by using MySQL administration tools (eg. phpMyAdmin, command line MySQL client, Navicat, etc).

<{note title="Moving the Database"}>To see how to move your old database, you may have a look at this <a href="https://www.activecollab.com/video/phpmyadmin-export.mov">short video</a>. The video demonstrates how to move the database using phpMyAdmin in three simple steps - selecting the database, making sure that all activeCollab tables are selected on the export tab, and, finally, saving the tables as a file.<{/note}>

After the database migration process is completed, you should move the content of the following folders to the new server:

- <{path}>/public/avatars<{/path}>
- <{path}>/public/logos<{/path}>
- <{path}>/public/notebook_covers<{/path}>
- <{path}>/public/projects_icons<{/path}>
- <{path}>/upload<{/path}>

activeCollab stores your binary data in those folders - images, uploads, etc. Do not forget to move them as well.

After the files are moved, please check the permissions and make sure that existing files are writable by PHP. If these files are read only, you will not be able to update them.

Now, **upgrade your database** to the latest version of activeCololab. In case you have already been using the latest version, the upgrade will not be necessary. 

To upgrade the database please visit **/public/upgrade/index.php** part of your activeCollab with your web browser. Log in with your administrator credentials and let the system upgrade your database.

After the upgrade is completed, **log in to your activeCollab**, then **rebuild the assets and empty the cache** from the <{option}>Admin Additional Menu<{/option}>. The data from your old installation should now be available in your new activeCollab instance.